<?php
/**
 * Terms & Conditions tab.
 *
 * @package 5th-social-bot
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class Fifth_Social_Bot_Terms
 */
class Fifth_Social_Bot_Terms {

    /**
     * Render terms tab.
     */
    public static function render_tab() {
        ?>
        <div class="fsb-card">
            <h2><?php echo esc_html( __( 'Terms and conditions of use', '5th-social-bot' ) ); ?></h2>

            <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( '5th Social Bot (Mastodon All-In-One Wordpress Plugin) is a WordPress plugin that sends content from your site to your Mastodon account on %s. By using this plugin, you agree to the terms below.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '1. Responsibility for content', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            echo esc_html(
                __( 'You are solely responsible for the content that is published from your WordPress site to Mastodon. The plugin does not create or moderate content by itself; it only sends text generated from your posts and pages according to the settings and templates you choose.', '5th-social-bot' )
            );
            ?>
        </p>

        <h3>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( '2. Compliance with %s rules', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
        </h3>
        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'Your use of this plugin must respect the local server rules and policies of %s. These rules are published on the instance\'s "About" page and may be updated at any time.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
        </p>
        <p>
            <?php echo esc_html__( 'You can read the current rules at:', '5th-social-bot' ); ?>
            <a href="https://social.5th.ro/about" target="_blank" rel="noreferrer noopener">https://social.5th.ro/about</a>
        </p>
        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'The administrators of %s may limit, suspend or block accounts, applications or bots that violate these rules (for example, spam, harassment, abusive automation or illegal content). Using this plugin does not grant any exemption from those rules.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '3. Rate limits and automation', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            echo esc_html(
                __( 'Although 5th Social Bot uses an internal queue and drip-feed mechanism (1 post every 5 minutes) to avoid aggressive posting, you should still configure it responsibly. Do not use this plugin to flood timelines, to spam hashtags or to attempt to bypass server-imposed rate limits.', '5th-social-bot' )
            );
            ?>
        </p>
        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'The plugin is designed to respect Mastodon rate limits and server policies. However, you are responsible for ensuring that your posting frequency and content comply with %s rules and do not constitute spam or harassment.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
        </p>
        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'The Auto-Boost feature includes configurable rate limits (1-10 boosts per day, 30 minutes to 2 hours interval between boosts) to prevent excessive boosting. You are responsible for configuring these limits appropriately and ensuring that your boost activity complies with the rules of both the primary instance (%s) and any secondary instances you configure.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '4. Access token storage and security', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'The personal access tokens for Mastodon instances (primary: %s, and optionally a secondary instance for Auto-Boost) that you enter in the plugin settings are stored in your WordPress database. They are used only to communicate with the configured Mastodon instances via their official APIs.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
        </p>
        <p>
            <?php
            echo esc_html(
                __( 'The plugin includes security features such as password-type input fields with show/hide toggles to protect your tokens from casual viewing. However, you are responsible for securing your WordPress installation, limiting access to the admin area, and revoking access tokens from your Mastodon accounts if you suspect that they have been compromised.', '5th-social-bot' )
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '5. Logs, privacy and data protection', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            echo esc_html(
                __( 'The plugin keeps a local log of recent operations (for example, successful posts and error messages) to help with debugging. These logs are stored only in your WordPress database and can be cleared at any time from the Log & debug tab. Only the most recent 200 log entries are kept.', '5th-social-bot' )
            );
            ?>
        </p>
        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'The plugin does not send analytics, tracking data or log entries to the plugin author or to any external service. All data remains on your server. The only external communication is with the Mastodon API (%s) when posting statuses or fetching feeds.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
        </p>
        <p>
            <?php
            echo esc_html(
                __( 'The plugin stores the following data in your WordPress database: (1) your Mastodon access tokens (primary and optionally secondary for Auto-Boost, encrypted by WordPress), (2) plugin settings (template, visibility, language, boost rate limits, etc.), (3) local logs of operations (maximum 200 entries), (4) post meta data indicating which posts have been posted to Mastodon and their URLs, (5) boost queue and statistics, and (6) cached feed data for shortcodes (temporary, with configurable cache time).', '5th-social-bot' )
            );
            ?>
        </p>
        <p>
            <?php
            echo esc_html(
                __( 'You remain responsible for informing your users, obtaining any necessary consents and ensuring that your use of the plugin complies with applicable privacy and data protection laws in your jurisdiction (for example, GDPR in the European Union).', '5th-social-bot' )
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '6. No warranty', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            echo esc_html(
                __( '5th Social Bot is provided “as is”, without any express or implied warranty. The authors and maintainers are not liable for any damages, loss of data, account suspension, loss of reputation or other issues that may arise from the use or inability to use this plugin.', '5th-social-bot' )
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '7. Changes to these terms', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            printf(
                /* translators: %s: link to plugin.5th.ro */
                esc_html__( 'These terms and conditions may be updated at any time. To view the latest version of these terms, please visit the official plugin website at %s.', '5th-social-bot' ),
                '<a href="https://plugin.5th.ro" target="_blank" rel="noopener noreferrer">https://plugin.5th.ro</a>'
            );
            ?>
        </p>
        <p>
            <?php
            echo esc_html(
                __( 'Continued use of the plugin after changes are published will be considered acceptance of the updated terms.', '5th-social-bot' )
            );
            ?>
        </p>

        <p>
            <?php
            echo esc_html(
                __( 'If you do not agree with these terms, please deactivate the plugin and remove it from your WordPress installation.', '5th-social-bot' )
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( '8. Official website and support', '5th-social-bot' ) ); ?></h3>
        <p>
            <?php
            printf(
                /* translators: %s: link to plugin.5th.ro */
                esc_html__( 'The official website of this plugin is %s.', '5th-social-bot' ),
                '<a href="https://plugin.5th.ro" target="_blank" rel="noopener noreferrer">https://plugin.5th.ro</a>'
            );
            ?>
        </p>
        <p>
            <?php
            // Get current site domain for support tracking.
            $support_url = 'https://plugin.5th.ro/support';
            printf(
                /* translators: %s: support URL */
                esc_html__( 'For support, please visit: %s', '5th-social-bot' ),
                '<a href="' . esc_url( $support_url ) . '" target="_blank" rel="noopener noreferrer">' . esc_html( $support_url ) . '</a>'
            );
            ?>
        </p>
        </div>
        <p style="margin-top: 2em; font-size: 12px; color: #666;">
            <?php
            printf(
                /* translators: %1$s: link to social.5th.ro, %2$s: link to plugin.5th.ro */
                wp_kses_post( __( 'Plugin created for WordPress → Mastodon (%1$s) integration. Official website: %2$s', '5th-social-bot' ) ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>',
                '<a href="https://plugin.5th.ro" target="_blank" rel="noopener noreferrer">plugin.5th.ro</a>'
            );
            ?>
            <br />
            <?php
            echo wp_kses_post(
                'Signed: <strong>SC ARC MEDIASOFT SRL</strong> — <a href="https://e-agentie.ro" target="_blank" rel="noopener noreferrer">e-agentie.ro</a>'
            );
            ?>
        </p>
        <?php
    }
}
