<?php
/**
 * Support & Contact tab.
 *
 * @package 5th-social-bot
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Class Fifth_Social_Bot_Support
 */
class Fifth_Social_Bot_Support {

    /**
     * Render support tab.
     */
    public static function render_tab() {
        ?>
        <div class="fsb-card">
            <h2><?php echo esc_html( __( 'Support & contact', '5th-social-bot' ) ); ?></h2>

            <p>
            <?php
            printf(
                /* translators: %s: link to plugin.5th.ro */
                esc_html__( 'The official website of this plugin is %s. For support, documentation, and the latest updates, please visit the official website.', '5th-social-bot' ),
                '<a href="https://plugin.5th.ro" target="_blank" rel="noopener noreferrer">https://plugin.5th.ro</a>'
            );
            ?>
            </p>
            <p>
            <?php
            $support_url = 'https://plugin.5th.ro/support';
            printf(
                /* translators: %s: support URL */
                esc_html__( 'For support requests, please visit: %s', '5th-social-bot' ),
                '<a href="' . esc_url( $support_url ) . '" target="_blank" rel="noopener noreferrer">' . esc_html( $support_url ) . '</a>'
            );
            ?>
            </p>
            <p>
            <?php
            echo esc_html(
                __( 'You can also contact the maintainer using the email address below.', '5th-social-bot' )
            );
            ?>
            </p>
        </div>

        <div class="fsb-card">
            <h2><?php echo esc_html( __( 'Contact', '5th-social-bot' ) ); ?></h2>
        <ul>
            <li>
                <?php
                $email = 'social_plugin@5th.ro';
                ?>
                <?php echo esc_html__( 'Email:', '5th-social-bot' ); ?>
                <a href="<?php echo esc_url( 'mailto:' . $email ); ?>"><?php echo esc_html( $email ); ?></a>
            </li>
            </ul>

            <p>
                <?php echo esc_html( __( 'When contacting us, please include:', '5th-social-bot' ) ); ?>
            </p>
            <ul>
            <li><?php echo esc_html( __( 'The URL of your WordPress site.', '5th-social-bot' ) ); ?></li>
            <li><?php echo esc_html( __( 'Your WordPress version and PHP version.', '5th-social-bot' ) ); ?></li>
            <li><?php echo esc_html( __( 'The plugin version (as shown on the plugins page).', '5th-social-bot' ) ); ?></li>
                <li><?php echo esc_html( __( 'A short description of what you were trying to do and what went wrong.', '5th-social-bot' ) ); ?></li>
            </ul>

            <div class="fsb-info-box warning">
                <p style="margin:0;">
                    <?php
                    echo esc_html(
                        __( 'For privacy reasons, do not send passwords, full database dumps or access tokens. If temporary access to your site is needed for debugging, please create a dedicated account with limited permissions and remove it afterwards.', '5th-social-bot' )
                    );
                    ?>
                </p>
            </div>
        </div>

        <div class="fsb-card">
            <h2>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'How to create a Mastodon access token on %s', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
            </h2>

            <p>
                <?php
                echo esc_html(
                    __( 'Follow the steps below to generate a personal access token that you can paste into the plugin settings.', '5th-social-bot' )
                );
                ?>
            </p>

            <ol>
            <li>
                <?php
                printf(
                    /* translators: %s: link to social.5th.ro */
                    esc_html__( 'Open %s in your browser.', '5th-social-bot' ),
                    '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">https://social.5th.ro</a>'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Create an account or log in to your existing account.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'In the Mastodon interface, open “Preferences → Development” (sometimes shown as “Settings → Development”).',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Click “New application”.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Choose a name for the application, for example “5th Social Bot”, and optionally add a short description so you remember what it is used for.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'In the permissions section, enable at least the following scopes: "write:statuses" (required to post statuses) and "read:accounts" (required to retrieve your username).',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Save the application. After saving, open the application details page.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                printf(
                    /* translators: %s: link to social.5th.ro */
                    esc_html__( 'Important: For profile verification to work, you need to add your WordPress domain to the whitelist. Go to "Preferences → Public profile → Verification" on %s. In the "Whitelist" section, add your domain (e.g., example.com or www.example.com - use the exact domain format that appears in your WordPress site URL). This allows Mastodon to verify that you own the website by checking for the rel="me" link that the plugin adds to your site.', '5th-social-bot' ),
                    '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'On the application details page, find the access token (sometimes labeled "Your access token") and copy the token value. Be careful to copy the entire token without extra spaces.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Return to WordPress and go to "5th Social Bot" menu. Paste the token into the "Mastodon access token" field. The field is password-protected by default for security - click "Show" to reveal it when needed.', 
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Click "Save settings" and then click "Check connection with Mastodon". If everything is configured correctly, you should see a "Connection OK" message with your account information. Your Mastodon username will be automatically retrieved and displayed.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'Optional: Configure additional settings such as post language (default: Romanian "ro"), enable profile verification, set up Auto-Boost to a second Mastodon instance, or configure shortcodes for displaying Mastodon content on your site.',
                    '5th-social-bot'
                );
                ?>
            </li>
        </ol>

        <p>
            <?php
            printf(
                /* translators: %s: link to social.5th.ro */
                esc_html__( 'Keep this token secret. Anyone who has access to it can post on your behalf on %s. If you suspect that the token has been exposed, revoke it from your Mastodon account and generate a new one.', '5th-social-bot' ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
            );
            ?>
        </p>
        </div>

        <div class="fsb-card">
            <h3><?php echo esc_html( __( 'Troubleshooting', '5th-social-bot' ) ); ?></h3>
            <ul>
            <li>
                <?php
                echo esc_html__(
                    'If the connection test fails, check that the token was copied completely and that there are no extra spaces before or after it. The token should be a long string of letters and numbers. The plugin automatically removes whitespace when saving, but it is best to copy the token carefully.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                printf(
                    /* translators: %s: link to social.5th.ro */
                    esc_html__( 'Make sure the application on %s has the required scopes enabled: "write:statuses" (to post statuses) and "read:accounts" (to retrieve your username). You can check and update these in the application settings.', '5th-social-bot' ),
                    '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
                );
                ?>
            </li>
            <li>
                <?php
                printf(
                    /* translators: %s: link to social.5th.ro */
                    esc_html__( 'If you see "HTTP 401" or "The access token is invalid" errors, the token may have expired or been revoked. Revoke the old token in %s, create a new one following the steps above, and update the token in the plugin settings.', '5th-social-bot' ),
                    '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
                );
                ?>
            </li>
            <li>
                <?php
                printf(
                    /* translators: %s: link to social.5th.ro */
                    esc_html__( 'If profile verification is not working, make sure: (1) verification is enabled in Settings, (2) your Mastodon username is set (automatically retrieved from your access token), (3) your domain is added to the whitelist in "Preferences → Public profile → Verification" on %s, and (4) the domain format matches exactly (e.g., if your site is www.example.com, add www.example.com to the whitelist, not just example.com).', '5th-social-bot' ),
                    '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'If posts are not being sent automatically, check: (1) "Auto-post for" is enabled for your post type (Posts or Pages) in Settings, (2) the post/page is published (not draft), (3) the post has not already been posted (check the Bulk & queue tab), and (4) your access token is valid.',
                    '5th-social-bot'
                );
                ?>
            </li>
            <li>
                <?php
                $social_link = '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>';
                printf(
                    /* translators: %1$s and %2$s: link to social.5th.ro */
                    esc_html__( 'If Auto-Boost is not working, check: (1) Auto-Boost is enabled in the Auto-Boost tab, (2) the primary account (%1$s) is configured, (3) the second instance URL and access token are correct, (4) rate limits are configured appropriately (check Boost Queue & Statistics in Bulk & queue tab), and (5) the post has been successfully posted to %2$s first.', '5th-social-bot' ),
                    wp_kses_post( $social_link ),
                    wp_kses_post( $social_link )
                );
                ?>
            </li>
            <li>
                <?php
                printf(
                    /* translators: %s: link to social.5th.ro */
                    esc_html__( 'If shortcodes are not displaying correctly, check: (1) your Mastodon username is set in Settings (automatically retrieved from access token), (2) for [mastodon_feed], verify the username or tag is correct, (3) check that the instance URL is correct (the plugin automatically corrects common typos like social5th.ro to %s), and (4) clear any caching plugins if feed content is not updating.', '5th-social-bot' ),
                    '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>'
                );
                ?>
            </li>
            <li>
                <?php
                echo esc_html__(
                    'If problems persist, enable Debug Mode in Settings and check the Log & debug tab for detailed error messages. Debug Mode logs additional information about shortcode execution, API interactions, and queue processing. This will help identify the specific issue.',
                    '5th-social-bot'
                );
                ?>
            </li>
            </ul>
        </div>

        <div class="fsb-card">
            <h2><?php echo esc_html( __( 'Additional Resources', '5th-social-bot' ) ); ?></h2>
            <p>
                <?php
                printf(
                    /* translators: %s: link to plugin.5th.ro */
                    esc_html__( 'For more information, documentation, and updates, visit the official plugin website: %s', '5th-social-bot' ),
                    '<a href="https://plugin.5th.ro" target="_blank" rel="noopener noreferrer">https://plugin.5th.ro</a>'
                );
                ?>
            </p>
        </div>
        
        <p style="margin-top: 2em; font-size: 12px; color: #666;">
            <?php
            printf(
                /* translators: %1$s: link to social.5th.ro, %2$s: link to plugin.5th.ro */
                wp_kses_post( __( 'Plugin created for WordPress → Mastodon (%1$s) integration. Official website: %2$s', '5th-social-bot' ) ),
                '<a href="https://social.5th.ro" target="_blank" rel="noopener noreferrer">social.5th.ro</a>',
                '<a href="https://plugin.5th.ro" target="_blank" rel="noopener noreferrer">plugin.5th.ro</a>'
            );
            ?>
            <br />
            <?php
            echo wp_kses_post(
                'Signed: <strong>SC ARC MEDIASOFT SRL</strong> — <a href="https://e-agentie.ro" target="_blank" rel="noopener noreferrer">e-agentie.ro</a>'
            );
            ?>
        </p>
        <?php
    }
}
