<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Simple logger stored in the `fifth_social_bot_log` option.
 */
class Fifth_Social_Bot_Logger {

    /**
     * Add entry to log.
     *
     * @param string $message Log message.
     * @param string $level   Log level (info|error).
     */
    public static function log( $message, $level = 'info' ) {
        $entry = array(
            'time'    => current_time( 'mysql' ),
            'level'   => (string) $level,
            'message' => (string) $message,
        );

        $log = get_option( 'fifth_social_bot_log', array() );
        if ( ! is_array( $log ) ) {
            $log = array();
        }

        $log[] = $entry;

        // Keep only last 200 entries.
        if ( count( $log ) > 200 ) {
            $log = array_slice( $log, -200 );
        }

        update_option( 'fifth_social_bot_log', $log, false );
    }

    /**
     * Get log entries.
     *
     * @return array
     */
    public static function get_log() {
        $log = get_option( 'fifth_social_bot_log', array() );
        if ( ! is_array( $log ) ) {
            $log = array();
        }
        return $log;
    }

    /**
     * Clear log.
     */
    public static function clear() {
        delete_option( 'fifth_social_bot_log' );
    }
}
